package gov.va.genisis2.schedule;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import gov.va.genisis2.bo.BusinessService;
import gov.va.genisis2.common.enums.CommonEnum;
import gov.va.genisis2.exceptions.ErrorEnum;

@Component
public class LdapRefreshScheduler {
	private static final Logger LOGGER = LoggerFactory.getLogger(LdapRefreshScheduler.class);
	@Autowired
	private BusinessService businessService;

	@Scheduled(cron = "${ldap.refresh.cron.expression}")
	public void refreshUserData() {
		if (LOGGER.isInfoEnabled()) {
			LOGGER.info("refreshUserData started....");
		}
		try {
			businessService.refreshUserData(CommonEnum.NIGHTLY_JOB.getText());
		} catch (Exception e) {
			LOGGER.error(ErrorEnum.LDAP_USERREFRESH_FAILED.getErrorMessage(), e);
		}
		if (LOGGER.isInfoEnabled()) {
			LOGGER.info("refreshUserData finished....");
		}
	}

	@Scheduled(cron = "${ldap.refresh.cron.expression}")
	public void refreshStudyApprovalData() {
		if (LOGGER.isInfoEnabled()) {
			LOGGER.info("refreshStudyApprovalData started....");
		}
		try {
			businessService.refreshLdapStudyApprovalData(CommonEnum.NIGHTLY_JOB.getText());
		} catch (Exception e) {
			LOGGER.error(ErrorEnum.LDAP_STUDYAPPROVAL_REFRESH_FAILED.getErrorMessage(), e);
		}
		if (LOGGER.isInfoEnabled()) {
			LOGGER.info("refreshStudyApprovalData finished....");
		}
	}
}
